#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"
#include "../generator.h"

static FbVertex pVertexIn[] = {
	{-1000.f,100.f,-1000.f, 255.f,255.f,255.f, 0,0,0, {0,0}},
	{1000.f,100.f,-1000.f, 0.f, 255.f, 0.f, 0,0,0, {1024,0}},
	{1000.f,100.f,1000.f, 0.f, 0.f, 255.f, 0,0,0, {256,256}},
	//{-1000.f,100.f,1000.f, 255.f, 0.f, 0.f, 0,0,0, {0,256}},
};
static GrVertex pVertexOut[sizeof(pVertexIn)/sizeof(FbVertex)];

Face pFace[] = {
	{0,1,2},
	//{2,3,0}
};

static Obj3d Cube = {
	pVertexIn,
	pVertexOut,
	sizeof(pVertexIn)/sizeof(FbVertex),
	pFace,
	sizeof(pFace)/sizeof(Face)
};
static float Matrix[16], Matrix2[16];

static Obj3d *pBouboule;

void LInit_Inside()
{
	unsigned int Cpt1;

	for(Cpt1=0;Cpt1<Cube.NbVertex;Cpt1++)
	{
		Cube.pVertexOut[Cpt1].r = Cube.pVertexIn[Cpt1].r;
		Cube.pVertexOut[Cpt1].g = Cube.pVertexIn[Cpt1].g;
		Cube.pVertexOut[Cpt1].b = Cube.pVertexIn[Cpt1].b;
	}

	pBouboule = GenerateSphere(50, 50, 800, 800, 1024, 1024);
	//pBouboule = GenerateFloor(10, 10, 1000, 1000, 256, 256);

	for(Cpt1=0;Cpt1<pBouboule->NbVertex;Cpt1++)
	{
		pBouboule->pVertexOut[Cpt1].r = rand()&255;
		pBouboule->pVertexOut[Cpt1].g = rand()&255;
		pBouboule->pVertexOut[Cpt1].b = rand()&255;
	}

}

void QInit_Inside()
{
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_LESS);
	grConstantColorValue(192<<24);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
	/*grColorCombine(GR_COMBINE_FUNCTION_LOCAL,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);*/
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	grCullMode(GR_CULL_DISABLE);
	grFogMode(GR_FOG_DISABLE);
	grChromakeyMode(GR_CHROMAKEY_DISABLE);

	DownloadTexture(&g_TextureBigrid);
	SelectTexture(g_TextureBigrid);
}

void Effect_Inside()
{
	//static float TransGoa = 1010.f;
	static float TransGoa = 1100.f;
	BeIdentityMatrix(Matrix);
	RotateXMatrix(Matrix2, Matrix, g_demostate.TickInEffect/500.f);
	RotateYMatrix(Matrix, Matrix2, g_demostate.TickInEffect/500.f);
	RotateZMatrix(Matrix2, Matrix, g_demostate.TickInEffect/500.f);
	//TranslateMatrix(Matrix2, 0, 500, TransGoa-=10);
	DrawWithMatrix(pBouboule, Matrix2, 0,0, 0);
}

void ByeBye_Inside()
{
	FreeTexture(&g_TextureBigrid);
}
